#pragma once

#include <ymod_smtpclient/call.h>
#include <ymod_smtpclient/client.h>

#include <yplatform/module.h>
#include <yplatform/reactor.h>
#include <yplatform/net/io_service.h>

#include <atomic>

namespace ymod_smtpclient {

class CallImpl:
    public Call,
    public yplatform::module,
    public boost::noncopyable
{
public:
    void init(const yplatform::ptree& conf);
    void init(yplatform::reactor_ptr reactor, const Settings& settings);

private:
    void asyncRun(Context ctx, Request request, Callback callback) override;
    void asyncRun(Context ctx, Request request, Options opts, Callback callback) override;
    SmtpSessionPtr createSmtpSession(Context ctx) override;
    SmtpSessionPtr createSmtpSession(Context ctx, const Timeouts& timeouts) override;
private:
    using ClientPtr = std::shared_ptr<Client>;

    Settings settings;
    std::unique_ptr<yplatform::net::io_service> yplatformIos;
    std::vector<ClientPtr> pool;
    std::atomic_uint poolIndx = {0};
};

}   // namespace ymod_smtpclient
