#pragma once

#include <boost/optional.hpp>
#include <string>

namespace ymod_smtpclient {

struct Command {
    std::string name;
    std::string args;
    char delim = ' ';
    boost::optional<std::string> debugArgs;

    std::string str() const {
        if (name.empty()) {
            return args + "\r\n";
        }
        if (args.empty()) {
            return name + "\r\n";
        }
        return name + delim + args + "\r\n";
    }

    std::string debugStr() const {
        if (name.empty()) {
            return debugArgs ? *debugArgs : args;
        }
        if (args.empty()) {
            return name;
        }
        return name + delim + (debugArgs ? *debugArgs : args);
    }
};

}   // namespace ymod_smtpclient
