#pragma once

#include "command.h"

#include <ymod_smtpclient/auth.h>
#include <ymod_smtpclient/request.h>
#include <ymod_smtpclient/smtp_point.h>

namespace ymod_smtpclient {

class Composer {
public:
    static Command HELLO(
        SmtpPoint::Proto proto = SmtpPoint::smtp,
        const std::string& hostname = std::string());
    static Command AUTH(sasl::Mechanism mechanism);
    static Command MAIL_FROM(const MailFrom& mailfrom);
    static Command RCPT_TO(const RcptTo& rcpt, bool enableDsn = false);
    static Command DATA_START();
    static Command STARTTLS();
    static Command RSET();
    static Command QUIT();
    static Command WITHOUT_NAME(const std::string& args, boost::optional<std::string> debug = {});
};

}   // namespace ymod_smtpclient
