#pragma once

namespace ymod_smtpclient {

struct DotStuffer {
    template <typename InputIterator, typename Container>
    void apply(InputIterator begin, InputIterator end, Container& destination) {
        for (auto now = begin; now != end; ++now) {
            switch (state) {
            case NEW_LINE:
                {
                    if (*now == '.') {
                        destination.append(begin, now);
                        destination.push_back('.');
                        begin = now;
                    }
                    if (*now != '\n') {
                        state = IN_LINE;
                    }
                    break;
                }
            case IN_LINE:
                {
                    if (*now == '\n') {
                        state = NEW_LINE;
                    }
                    break;
                }
            }
        }
        destination.append(begin, end);
    }

private:
    typedef enum {NEW_LINE, IN_LINE} State;

    State state = NEW_LINE;
};

}   // namespace ymod_smtp_client
