#include <ymod_smtpclient/request.h>

namespace ymod_smtpclient {

std::string to_string(NotifyMode type) {
    switch(type) {
    case NotifyMode::Never:
        return "NEVER";
    case NotifyMode::Success:
        return "SUCCESS";
    case NotifyMode::Failure:
        return "FAILURE";
    case NotifyMode::Delay:
        return "DELAY";
    default:
        throw std::runtime_error("Unknown 'NOTIFY' parameter value: " + std::to_string(int(type)));
    }
}

RequestBuilder& RequestBuilder::address(const SmtpPoint& point) {
    data.address = point;
    return *this;
}

RequestBuilder& RequestBuilder::mailfrom(MailFrom value) {
    data.mailfrom = std::move(value);
    return *this;
}

RequestBuilder& RequestBuilder::auth(AuthData authData) {
    data.auth.reset(std::move(authData));
    return *this;
}

RequestBuilder& RequestBuilder::addRcpt(RcptTo rcpt) {
    data.rcpts.push_back(std::move(rcpt));
    return *this;
}

RequestBuilder& RequestBuilder::message(std::string msg) {
    data.message = std::make_shared<std::string>(std::move(msg));
    return *this;
}

Request RequestBuilder::release() {
    Request retval;
    std::swap(retval, data);
    return retval;
}

}   // namespace smtpclient
