#pragma once

#include <ymod_smtpclient/call.h>
#include <yplatform/time_traits.h>
#include <memory>

namespace ymod_smtpclient {

struct RequestData {
    using Context = Call::Context;
    using Callback = Call::Callback;
    using duration = yplatform::time_traits::duration;
    using time_point = yplatform::time_traits::time_point;

    Request data;
    Context ctx;
    Callback callback;
    Timeouts timeouts;
    bool reuseConnection = false;
    bool allowRcptToErrors = true;
    bool dotStuffing = true;
    Optional<bool> useSsl;

    time_point startedAt = time_point::min();
    duration totalTime = duration::zero();

    Response response;
};

using RequestDataPtr = std::shared_ptr<RequestData>;

}   // namespace ymod_smtpclient
