#pragma once

#include "types.h"
#include "server_response.h"
#include "server_response_filter.h"

#include <ymod_smtpclient/errors.h>

#include <yplatform/net/socket.h>
#include <yplatform/yield.h>
#include <yplatform/coroutine.h>
#include <yplatform/task_context.h>

namespace ymod_smtpclient {

class ResponseReader : public yplatform::log::contains_logger {
public:
    using YieldCtx = yplatform::yield_context<ResponseReader>;
    using Response = MultiLineResponse;
    using CompletionHandler = std::function<void(error::Code, Response)>;

    ResponseReader(
        Socket& socket,
        Buffer& readBuf,
        Duration timeout,
        const ContextPtr& ctx,
        const yplatform::log::source& logger,
        CompletionHandler&& handler);

    void operator()(
        YieldCtx yieldCtx,
        error::Code errc = error::Success,
        std::string line = std::string());

private:
    Response resp;
    Socket& socket;
    Buffer& readBuf;
    Duration timeout;
    CompletionHandler completionHandler;
    ServerResponseFilter smtpFilter;
    ContextPtr ctx;

    void asyncReadLine(Duration timeout, YieldCtx handler);

    bool updateMultilineResponse(const std::string& line);
};

}  // namespace ymod_smtpclient
