#pragma once

#include <ymod_smtpclient/auth.h>

#include <cinttypes>
#include <string>

#include <boost/noncopyable.hpp>

#include "../server_response.h"
#include "../command.h"

namespace ymod_smtpclient {
namespace sasl {

class ClientEngine final: public boost::noncopyable {
public:
    enum class Status: std::uint8_t
    {
        // Operation done. Client must inspect server response to determine if
        // authentication was successful.
        Done,

        // Next stage wanted. Client must send command if provided and read
        // one more response line.
        More,

        // Something went wrong. If server response looks good from SMTP
        // perspective then there was something with the data.
        Form
    };

    // Construct a new engine
    explicit ClientEngine(std::size_t maxCommandLength = 512);

    // Start new authentication exchange.
    void reset(const AuthData& authdata);

    // Perform next step of the authentication exchange. This method assumes
    // that response contains a valid SMTP response line.
    Status next(const MultiLineResponse& response, Command& command);

    static std::string makePlain(const std::string& login, const std::string& password);
    static std::string makeOauthBearer(const std::string& user, const std::string& token);

private:
    Status handleLogin(const MultiLineResponse& response, Command& command);
    Status handlePlain(const MultiLineResponse& response, Command& command);
    Status handleOauth(const MultiLineResponse& response, Command& command);

    const std::size_t maxCommandLength;

    enum class State : std::uint8_t;
    State state;

    AuthData authdata;
};

}   // namespace sasl
}   // namespace ymod_smtpclient
