#pragma once

#include <ymod_smtpclient/response.h>
#include <vector>

namespace ymod_smtpclient {
namespace server {

struct OneLineResponse {
    uint16_t replyCode = 0;
    Optional<EnhancedStatusCode> enhancedCode;
    std::string data;
};

// first - server response line,
// second - is the last line in response
std::pair<OneLineResponse, bool> parseResponse(const std::string& response);

}   // namespace server

OneResponse multiline2OneLineResponse(const MultiLineResponse& response);

}   // namespace ymod_smtpclient
