#pragma once

#include <yplatform/net/filter.h>

namespace ymod_smtpclient {

// find \r\n
class ServerResponseFilter: public yplatform::net::proto_filter {
public:
    template <typename Iterator>
    std::pair<Iterator, bool> operator()(Iterator begin, Iterator end) {
        for (auto it = begin; it != end; ++it) {
            if (*it == '\n' && cr) {
                cr = false;
                return std::make_pair(it, true);
            } else if (*it == '\r') {
                cr = true;
            } else {
                cr = false;
            }
        }
        return std::make_pair(end, false);
    }
private:
    bool cr = false;
};

}   // namespace ymod_smtpclient

namespace boost {
namespace asio {

    template <>
    struct is_match_condition<ymod_smtpclient::ServerResponseFilter> : public boost::true_type {};

}   // namespace asio
}   // namespace boost
