#pragma once

#include <ymod_smtpclient/request.h>

namespace ymod_smtpclient {

struct SessionInfo {
    SmtpPoint point;
    Optional<AuthData> authdata;
    Optional<bool> useSsl;
};

inline bool operator<(const AuthData& a, const AuthData& b) {
    return std::tie(a.mechanism, a.login, a.password, a.token)
        < std::tie(b.mechanism, b.login, b.password, b.token);
}

inline bool operator<(const SmtpPoint& a, const SmtpPoint& b) {
    return std::tie(a.proto, a.host, a.port) < std::tie(b.proto, b.host, b.port);
}

inline bool operator<(const SessionInfo& a, const SessionInfo& b) {
    return std::tie(a.point, a.authdata, a.useSsl) < std::tie(b.point, b.authdata, b.useSsl);
}

}   // namespace ymod_smtpclient
