#pragma once

#include <boost/variant.hpp>
#include <boost/range/iterator_range.hpp>

#include <map>
#include <string>

namespace ymod_smtpserver {
namespace commands {

struct Lhlo {
    explicit Lhlo(std::string name = std::string()) : name(std::move(name)) {}

    std::string name;
};

struct Ehlo {
    explicit Ehlo(std::string name = std::string()) : name(std::move(name)) {}

    std::string name;
};

struct Helo {
    explicit Helo(std::string name = std::string()) : name(std::move(name)) {}

    std::string name;
};

using Params = std::map<std::string, std::string>;

struct MailFrom {
    explicit MailFrom(std::string addr = std::string(), Params params = Params())
        : addr(std::move(addr))
        , params(std::move(params))
    {}

    std::string addr;
    Params params;
};

struct RcptTo {
    explicit RcptTo(std::string addr = std::string(), Params params = Params())
        : addr(std::move(addr))
        , params(std::move(params))
    {}

    std::string addr;
    Params params;
};

struct Data {};

struct Rset {};

struct Quit {};

struct StartTls {};

struct Noop {};

namespace AuthMethods {

struct Login {};
struct Plain {};
struct XOAuth2 {};
struct NotSupported {};

inline std::ostream& operator<<(std::ostream& os, const Login&) {
    os << "AuthMethodLogin";
    return os;
}

inline std::ostream& operator<<(std::ostream& os, const Plain&) {
    os << "AuthMethodPlain";
    return os;
}

inline std::ostream& operator<<(std::ostream& os, const XOAuth2&) {
    os << "AuthMethodXOAuth2";
    return os;
}

inline std::ostream& operator<<(std::ostream& os, const NotSupported&) {
    os << "AuthMethodNotSupported";
    return os;
}

}

using AuthMethod = boost::variant<
    AuthMethods::Login,
    AuthMethods::Plain,
    AuthMethods::XOAuth2,
    AuthMethods::NotSupported>;

struct Auth {
    Auth(AuthMethod method = AuthMethods::NotSupported{}, std::string initialResponse = std::string{}) 
        : Method(std::move(method))
        , InitialResponse(std::move(initialResponse))
    {}

    AuthMethod Method;
    std::string InitialResponse;
};

struct SyntaxError {
    template <typename Iterator>
    explicit SyntaxError(boost::iterator_range<Iterator> ctx): ctx(ctx.begin(), ctx.end()) {}

    SyntaxError() {}

    std::string ctx;
};

struct Unknown {
    template <typename Iterator>
    explicit Unknown(boost::iterator_range<Iterator> ctx): ctx(ctx.begin(), ctx.end()) {}

    Unknown() {}

    std::string ctx;
};

using Command =
    boost::variant<
      Lhlo
    , Ehlo
    , Helo
    , MailFrom
    , RcptTo
    , Data
    , Quit
    , Rset
    , StartTls
    , Noop
    , Auth
    , SyntaxError
    , Unknown
    >;

} // namespace commands

using Command = commands::Command;

}   // namespace ymod_smtpserver
