#pragma once

#include <ymod_smtpserver/commands.h>
#include <ymod_smtpserver/response.h>

#include <yplatform/task_context.h>
#include <yplatform/time_traits.h>
#include <openssl/ossl_typ.h>
#include <boost/asio/ip/address.hpp>
#include <boost/asio/io_service.hpp>
#include <functional>
#include <memory>
#include <string>
#include <vector>

namespace ymod_smtpserver {

using ConnectionPtr = std::shared_ptr<class Connection>;

class Connection {
public:
    using StringPtr = std::shared_ptr<std::string>;
    using OnCloseCallback = std::function<void (ConnectionPtr)>;
    using TlsHandshakeCallback = std::function<void (boost::system::error_code)>;
    using ReadCommandCallback = std::function<void (boost::system::error_code, Command)>;
    using ReadMessageCallback = std::function<void (boost::system::error_code, StringPtr)>;
    using ReadLineCallback = std::function<void (boost::system::error_code, std::string)>;
    using WriteResponseCallback = std::function<void (boost::system::error_code, std::size_t)>;

    virtual ~Connection() {}

    virtual void close() = 0;

    virtual bool isOpen() const = 0;
    virtual bool isSecure() const = 0;

    virtual void tlsHandshake(TlsHandshakeCallback callback) = 0;

    virtual void readCommand(ReadCommandCallback callback) = 0;
    virtual void readMessage(ReadMessageCallback callback) = 0;
    virtual void readLine(ReadLineCallback callback) = 0;

    virtual void writeResponse(Response response, WriteResponseCallback callback) = 0;
    virtual void bufferResponse(Response response) = 0;

    virtual void writeResponses(const std::vector<Response>& responses, WriteResponseCallback callback) = 0;
    virtual void bufferResponses(const std::vector<Response>& responses) = 0;

    virtual const boost::asio::ip::address& remoteAddr() const = 0;
    virtual unsigned short remotePort() const = 0;
    virtual const boost::asio::ip::address& localAddr() const = 0;
    virtual unsigned short localPort() const = 0;
    virtual const void* id() const = 0;
    virtual SSL* getSsl() = 0;

    virtual boost::asio::io_service& ioService() = 0;

    virtual yplatform::task_context_ptr ctx() const = 0;
    virtual yplatform::time_traits::time_point startTime() const = 0;
};

}   // namespace ymod_smtpserver
