#pragma once

#include <ymod_smtpserver/connection.h>

namespace ymod_smtpserver {

class Session {
public:
    explicit Session(ConnectionPtr connection): connection(connection) {}
    virtual ~Session() {}

    virtual void start() = 0;

protected:
    ConnectionPtr connection;
};

using SessionPtr = std::shared_ptr<Session>;

class SessionFactory {
public:
    virtual ~SessionFactory() {}

    virtual SessionPtr create(ConnectionPtr connection) = 0;
};

using SessionFactoryPtr = std::shared_ptr<SessionFactory>;

}   // namespace ymod_smtpserver
