#pragma once

#include <ymod_smtpserver/server.h>
#include "settings.h"
#include "manager.h"

#include <yplatform/module.h>
#include <yplatform/net/server.h>

#include <vector>

namespace ymod_smtpserver {

class Impl: public Server, public yplatform::module {
public:
    void init(const yplatform::ptree& conf);
    void start();
    void stop();
    yplatform::ptree get_stats() const override { return connManager->getStats(); }

    void setFactory(SessionFactoryPtr sessionFactory) override { factory = sessionFactory; }

private:
    struct NetBox {
        std::shared_ptr<yplatform::net::io_data> iodata;
        std::vector<yplatform::net::tcp_server> tcpServers;
    };
    std::vector<NetBox> boxes;

    std::shared_ptr<Settings> settings;
    yplatform::reactor_ptr reactor;
    SessionFactoryPtr factory;
    ConnectionManagerPtr connManager;
};

}   // namespace ymod_smtpserver
