#pragma once

#include <ymod_smtpserver/connection.h>

#include <mutex>
#include <unordered_set>
#include <shared_mutex>

namespace ymod_smtpserver {

class ConnectionManager: public yplatform::log::contains_logger {
public:
    explicit ConnectionManager(const yplatform::log::source& logger)
        : yplatform::log::contains_logger(logger)
    {}

    void registerConnection(Connection* conn);
    void onDestroy(Connection* conn);

    yplatform::ptree getStats() const;

private:
    using ReadLock = std::shared_lock<std::shared_timed_mutex>;
    using WriteLock = std::unique_lock<std::shared_timed_mutex>;

    mutable std::shared_timed_mutex mutex;
    std::unordered_set<Connection*> connections;
};

using ConnectionManagerPtr = std::shared_ptr<ConnectionManager>;
using ConnectionManagerWeakPtr = std::weak_ptr<ConnectionManager>;

}   // namespace ymod_smtpserver
