## ymod_statserver

### Что это?
Модуль платформы для получения статистики в формате json или xml (считается устаревшим):
- трассировка реакторов в мс. Отдается крайнее измеренное значение и максимальное значение за последние 60 секунд (реакторы трассируются раз в секунду). Трассировка это пустая операция на реакторе. Измеряется время задержки между добавлением операции в пул реактора и успешным выполнением. Позволяет понять, насколько забит пул реактора.
- статистика модулей - вызывает метод get_stats() каждого модуля.
- информация о контекстах из global_context_repository.
- время работы приложения.

Статсервер работает по tcp протоколу. После того, как клиент соединяется, статсервер отдает статистику и обрывает соединение.

### Пример конфигурации
```
-   _name: stat_server
    system:
        name: stat_server
        factory: ymod_stat_server::impl
    configuration:
        reactor: stat_server
        dump_json: true # по умолчанию xml
        trace_reactors: true # возвращать трассировку реакторов в мс, по умолчанию включено
        dump_sessions: true # возвращать информацию о контекстах, по умолчанию выключено
        path_read_timeout: 0.05 # время ожидания для передачи пути, по умолчанию 50 мс
```

### Пример использования
```
vyserenity ~ $ nc localhost 8091
{
    "stat": {
        "modules": {
            "stat_server": {
                "reactors": {
                    "stat_server0-trace": "0",
                    "web0-trace": "0",
                },
                "max_latency_in_last_minute": {
                    "stat_server0": "1",
                    "web0": "2",
                }
            },
            "web_server": {
                "rps": "0",
                "rps_avg_min": "0"
            },
        },
        "uptime": "00:00:07.279347"
    }
}
```

Для json версии реализована возможность передать путь, чтобы получить только нужную статистику

### Пример использования для продвинутых
```
vyserenity ~ $ echo -n stat.modules.web_server | nc localhost 8091
{
    "stat": {
        "modules": {
            "web_server": {
                "rps": "0",
                "rps_avg_min": "0"
            }
        }
    }
}
```
