#pragma once

#include "settings.h"
#include <yplatform/net/socket.h>
#include <yplatform/net/line_filter.h>
#include <yplatform/ptree.h>
#include <boost/enable_shared_from_this.hpp>

namespace ymod_stat_server {

using yplatform::net::tcp_socket;

struct request
{
    bool dump_stat = true;
    bool dump_sessions = true;
    bool dump_modules = true;
    bool dump_uptime = true;

    std::string module_name;
    std::string module_path;
};

class session
    : public boost::enable_shared_from_this<session>
    , public yplatform::log::contains_logger
{
public:
    session(tcp_socket&& socket, const settings& settings);
    ~session();
    void start();

private:
    void respond(const request& req);

    yplatform::ptree make_response_data(const request& req) const;
    void write_xml(std::ostream& stream) const;
    static void ptree_to_xml(const yplatform::ptree& data, std::ostream& stream, int indent);
    void handle_quit(boost::system::error_code const& e, std::size_t bytes);
    tcp_socket socket_;
    settings settings_;
    boost::asio::streambuf write_buffer_;
    boost::asio::streambuf read_buffer_;
};

}
