#pragma once

#include <yplatform/net/settings.h>
#include <yplatform/time_traits.h>

namespace ymod_stat_server {

struct settings
{
    yplatform::net::server_settings socket;
    bool dump_json = false;
    bool dump_sessions = false;
    std::string listen_addr;
    unsigned short listen_port = 0;
    std::string pa_log_file;
    size_t pa_max_size = 1000 * 1000;
    size_t pa_dump_size = 256;
    bool trace_reactors = true;
    size_t path_max_size = 4096;
    yplatform::time_traits::duration path_read_timeout = yplatform::time_traits::milliseconds(50);

    void parse_ptree(const yplatform::ptree& cfg)
    {
        if (auto socket_cfg = cfg.get_child_optional("socket"))
        {
            socket.parse_ptree(*socket_cfg);
        }

        auto listen_cfg = cfg.get_child_optional("endpoints.listen");
        if (!listen_cfg) listen_cfg = cfg.get_child_optional("listen");
        if (listen_cfg)
        {
            listen_addr = listen_cfg->get<std::string>("<xmlattr>.addr", "");
            if (listen_addr.empty()) listen_addr = listen_cfg->get<std::string>("addr", "");
            listen_port = listen_cfg->get<unsigned short>("<xmlattr>.port", 0);
            if (!listen_port) listen_port = listen_cfg->get<unsigned short>("port", 0);
        }

        dump_json = cfg.get("dump_json", dump_json);
        dump_sessions = cfg.get("dump_sessions", dump_sessions);
        if (cfg.get("pa.<xmlattr>.enable", 0))
        {
            pa_log_file = cfg.get("pa.<xmlattr>.path", "");
            pa_max_size = cfg.get("pa.<xmlattr>.max_size", pa_max_size);
            pa_dump_size = cfg.get("pa.<xmlattr>.dump_size", pa_dump_size);
        }
        trace_reactors = cfg.get("trace_reactors", trace_reactors);

        path_max_size = cfg.get("path_max_size", path_max_size);
        path_read_timeout = cfg.get("path_read_timeout", path_read_timeout);
    }
};

}
