#pragma once

#include <ymod_tvm/types.h>
#include <ymod_httpclient/cluster_client.h>
#include <yplatform/ptree.h>

#include <boost/date_time/posix_time/posix_time.hpp>
#include <boost/beast/core/string.hpp>
#include <map>
#include <memory>
#include <set>

namespace ymod_tvm { namespace tvm2 {

struct settings
{
    struct service_info
    {
        uint32_t id;
        std::set<string> hosts;
    };
    using mapping_t = std::map<string, service_info>;

    static mapping_t read_mappings(const yplatform::ptree& conf, const string& node = "mappings");

    settings();

    settings(const yplatform::ptree& conf);

    uint32_t my_tvm_id = 0;
    string target_services;
    string keys_request;
    string keys_file;
    string tickets_request;
    std::map<string, string> target_services_by_id;
    std::set<blackbox_env> blackbox_envs;
    string tvm_secret;
    duration keys_update_interval;
    duration tickets_update_interval;
    duration retry_interval;
    bool log_debug_info;
    bool wait_first_update_on_start;
    yhttp::cluster_client::settings http;
    std::map<string, string, boost::beast::iless> tvm_service_by_host;
};

}}
