#pragma once

#include <ymod_tvm/module.h>
#include <ymod_tvm/settings.h>
#include <ticket_provider/for_host.h>
#include <yplatform/reactor.h>

namespace ymod_tvm {
namespace tvm2 {
class impl;
}

class interface: public tvm2_module, public ticket_provider::for_host
{
public:
    virtual void bind_host(const std::string& host, const std::string& service) = 0;
};

class tvm : public interface
{
public:
    using tvm2_module::tickets_ready_callback;
    using tvm2_module::callback;

    tvm(tvm2::settings settings);
    tvm(boost::asio::io_service& io, tvm2::settings settings);
    tvm(yplatform::reactor& reactor, tvm2::settings settings);

    void start();

    ~tvm();

    // TVM2 interface.

    void subscribe_service_ticket(const std::string& service, const tickets_ready_callback& cbs)
        override;

    void subscribe_all_tickets_are_ready(const callback& cbs) override;

    boost::system::error_code check_service_ticket(task_context_ptr ctx, const std::string& ticket)
        override;

    boost::optional<tvm2::service_ticket> get_native_service_ticket(
        task_context_ptr ctx,
        const std::string& ticket) override;

    boost::variant<error_code, tvm2::service_ticket> get_native_service_ticket_or_error(
        const std::string& ticket) override;

    boost::system::error_code get_service_ticket(const std::string& service, std::string& ticket)
        override;

    std::tuple<boost::system::error_code, std::string> get_service_ticket_for_host(
        const std::string& host) override;

    virtual void bind_host(const std::string& host, const std::string& service) override;

    boost::system::error_code check_user_ticket(
        task_context_ptr ctx,
        tvm2::blackbox_env env,
        const std::string& ticket) override;

    boost::optional<tvm2::user_ticket> get_native_user_ticket(
        task_context_ptr ctx,
        tvm2::blackbox_env env,
        const std::string& ticket) override;

    boost::variant<error_code, tvm2::user_ticket> get_native_user_ticket_or_error(
        tvm2::blackbox_env env,
        const std::string& ticket) override;

    void subscribe_keys_loaded(const callback& cb) override;

private:
    std::shared_ptr<yplatform::reactor> reactor_;
    std::shared_ptr<tvm2::impl> impl_;
    friend class tvm2::impl; // Allow impl to access impl_.
};

}
