#pragma once

#include <yplatform/time_traits.h>
#include <library/c/tvmauth/tvmauth_wrapper.h>
#include <library/c/tvmauth/deprecated_wrapper.h>

namespace ymod_tvm { namespace tvm2 {

using std::string;
using yplatform::time_traits::duration;
using yplatform::time_traits::timer;
using service_context = NTvmAuthWrapper::TServiceContext;
using service_ticket = NTvmAuthWrapper::TCheckedServiceTicket;
using user_context = NTvmAuthWrapper::TUserContext;
using user_ticket = NTvmAuthWrapper::TCheckedUserTicket;
using blackbox_env = TA_EBlackboxEnv;

// Tries to resolve blackbox_env by name as follows:
// "blackbox"           TA_BE_PROD
// "blackbox-test"      TA_BE_TEST
// "blackbox-corp"      TA_BE_PROD_YATEAM
// "blackbox-corp-test" TA_BE_TEST_YATEAM
// "blackbox-stress"    TA_BE_STRESS
// "blackbox-mimino"    TA_BE_PROD
bool blackbox_env_by_name(const string& name, blackbox_env& env);

}}
