include(find_ymod_tvm_dependencies)

if(ymod_tvm_INCLUDE_DIR AND ymod_tvm_LIBRARIES)
  set(ymod_tvm_FIND_QUIETLY TRUE)
endif()

find_path(ymod_tvm_INCLUDE_DIR
  NAMES ymod_tvm/module.h
  HINTS ${CMAKE_INSTALL_PREFIX}/include)

find_library(ymod_tvm_LIBRARY
  NAMES ymod_tvm
  HINTS ${CMAKE_INSTALL_PREFIX}
  PATH_SUFFIXES .libs lib lib64)

find_ymod_tvm_dependencies()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(ymod_tvm DEFAULT_MSG
  ymod_tvm_INCLUDE_DIR ymod_tvm_LIBRARY)

if(YMOD_TVM_FOUND)
  list(APPEND ymod_tvm_INCLUDE_DIR ${ymod_tvm_DEPENDENCY_INCLUDE_DIRS})
  set(ymod_tvm_LIBRARIES
    "-Wl,--whole-archive ${ymod_tvm_LIBRARY} -Wl,--no-whole-archive"
    ${ymod_tvm_DEPENDENCY_LIBRARIES}
  )
  set(YMOD_TVM_INCLUDE_DIR ${ymod_tvm_INCLUDE_DIR} CACHE INTERNAL "")
  set(YMOD_TVM_LIBRARIES ${ymod_tvm_LIBRARIES} CACHE INTERNAL "")
endif()

mark_as_advanced(ymod_tvm_INCLUDE_DIR ymod_tvm_LIBRARIES)
