#include "blackbox_env.h"

#include <map>

namespace ymod_tvm { namespace tvm2 {

// Stores blackbox tvm id and libticket-parser2 id by blackbox environment name.
const std::map<std::string, std::pair<const char*, blackbox_env>> envs_by_name = {
    { "blackbox", { TA_BlackboxTvmIdProd, TA_BE_PROD } },
    { "blackbox-test", { TA_BlackboxTvmIdTest, TA_BE_TEST } },
    { "blackbox-corp", { TA_BlackboxTvmIdProdYateam, TA_BE_PROD_YATEAM } },
    { "blackbox-corp-test", { TA_BlackboxTvmIdTestYateam, TA_BE_TEST_YATEAM } },
    { "blackbox-stress", { TA_BlackboxTvmIdStress, TA_BE_STRESS } },
    { "blackbox-mimino", { TA_BlackboxTvmIdMimino, TA_BE_PROD } }
};

const char* blackbox_tvm_id_by_name(const std::string& name)
{
    auto it = envs_by_name.find(name);
    return it == envs_by_name.end() ? nullptr : it->second.first;
}

bool blackbox_env_by_name(const std::string& name, blackbox_env& env)
{
    auto it = envs_by_name.find(name);
    if (it == envs_by_name.end()) return false;
    env = it->second.second;
    return true;
}

}}
