#pragma once
#include <ymod_tvm/types.h>
#include <fstream>
#include <sstream>

namespace ymod_tvm { namespace tvm2 {

inline string read_file(const string& file_name)
{
    std::ifstream fs(file_name);
    if (!fs.is_open() || !fs.good()) throw std::runtime_error("failed to open file " + file_name);
    string res(std::istream_iterator<char>(fs >> std::noskipws), std::istream_iterator<char>());
    if (!fs.eof()) throw std::runtime_error("failed to read file " + file_name);
    return res;
}

}}