#include "average_metric.h"

#include <util/system/guard.h>

namespace NYmodUnistat {

TAverageMetric::TAverageMetric()
    : Data{0, 0}
{}

void TAverageMetric::Push(double value) {
    auto guard = Guard(Lock);
    Data.Value += value;
    ++Data.Count;
}

TAverageMetric::TValue TAverageMetric::GetValue(bool reset) {
    auto guard = Guard(Lock);
    double res = Data.Count > 0 ? Data.Value / Data.Count : Data.Value;
    if (reset) {
        Data = {0, 0};
    }
    return res;
}

void TAverageMetric::Reset() {
    auto guard = Guard(Lock);
    Data = {0, 0};
}

} // namespace NYmodUnistat
