#pragma once

#include "metric.h"

#include <util/system/spinlock.h>

namespace NYmodUnistat {

class TAverageMetric : public TMetric {
public:
    TAverageMetric();

    void Push(double value) override;
    TValue GetValue(bool reset) override;
    void Reset() override;

private:
    struct TData {
        double Value;
        uint64_t Count;
    };

    TData Data;
    TAdaptiveLock Lock;
};

} // namespace NYmodUnistat
