#pragma once

#include "metric.h"

#include <atomic>
#include <memory>
#include <vector>

namespace NYmodUnistat {

class THistogramMetric : public TMetric {
public:
    using TBorders = std::vector<double>;

    explicit THistogramMetric(TBorders borders);

    void Push(double value) override;
    TValue GetValue(bool reset) override;
    void Reset() override;

private:
    using TIntervalData = std::pair<double, std::unique_ptr<std::atomic_uint64_t>>;

    std::vector<TIntervalData> Values;
};

} // namespace NYmodUnistat
