#pragma once

#include <memory>
#include <variant>
#include <vector>
#include <cstdint>

namespace NYmodUnistat {

class TMetric {
public:
    using THistogramValues = std::vector<std::pair<double, uint64_t>>;
    using TValue = std::variant<std::monostate, double, THistogramValues>;

    virtual ~TMetric() = default;

    virtual void Push(double value) = 0;
    virtual TValue GetValue(bool reset) = 0;
    virtual void Reset() = 0;
};

using TMetricPtr = std::unique_ptr<TMetric>;

} // namespace NYmodUnistat
