#pragma once

#include "numerical_metric.h"

namespace NYmodUnistat {

class TMinMetric : public TNumericalMetric {
public:
    explicit TMinMetric(double startValue)
        : TNumericalMetric(startValue)
    {}

    double CalcNewValue(double current, double value) override {
        return value < current ? value : current;
    }
};

} // namespace NYmodUnistat
