#include "numerical_metric.h"

namespace NYmodUnistat {

TNumericalMetric::TNumericalMetric(double startValue)
    : StartValue(startValue)
    , Value(StartValue)
{}

void TNumericalMetric::Push(double value) {
    double currValue = Value.load(std::memory_order_acquire);
    double newValue;
    do {
        newValue = CalcNewValue(currValue, value);
    } while (!Value.compare_exchange_weak(currValue, newValue, std::memory_order_acq_rel));
}

TNumericalMetric::TValue TNumericalMetric::GetValue(bool reset) {
    return reset ? Value.exchange(StartValue, std::memory_order_acq_rel) : Value.load(std::memory_order_acquire);
}

void TNumericalMetric::Reset() {
    Value.store(StartValue, std::memory_order_release);
}

double TNumericalMetric::GetStartValue() const {
    return StartValue;
}

} // namespace NYmodUnistat
