#pragma once

#include "metric.h"

#include <atomic>

namespace NYmodUnistat {

class TNumericalMetric : public TMetric {
public:
    explicit TNumericalMetric(double startValue);

    void Push(double value) override;
    TValue GetValue(bool reset) override;
    void Reset() override;

protected:
    double GetStartValue() const;
    virtual double CalcNewValue(double current, double value) = 0;

private:
    double StartValue;
    std::atomic<double> Value;
};

} // namespace NYmodUnistat
