#pragma once

#include "sum_metric.h"

namespace NYmodUnistat {

class TSumNoneMetric : public TSumMetric {
public:
    explicit TSumNoneMetric(double startValue)
        : TSumMetric(startValue)
    {}

    TValue GetValue(bool reset) override {
        const auto value = TSumMetric::GetValue(reset);
        return std::get<double>(value) == GetStartValue() ? TValue{} : value;
    }
};

} // namespace NYmodUnistat
