#include "module.h"
#include "module_impl.h"

#include <yplatform/module_registration.h>

namespace NYmodUnistat {

TModule::TModule()
    : Impl(std::make_unique<TModuleImpl>())
{}

TModule::~TModule() = default;

void TModule::init(const yplatform::ptree& configuration) {
    Impl->Init(configuration);
}

void TModule::Push(const std::string& signal, double value) {
    Impl->Push(signal, value);
}

TMetric::TValue TModule::GetValue(const std::string& signal, bool reset) {
    return Impl->GetValue(signal, reset);
}

TModule::TValues TModule::GetValues(bool reset) {
    return Impl->GetValues(reset);
}

std::string TModule::GetValuesInJson(bool reset) {
    return Impl->GetValuesInJson(reset);
}

void TModule::ResetAll() {
    Impl->ResetAll();
}

TMetricPtr TModule::SetHandler(const std::string& signal, TMetricPtr metric) {
    return Impl->SetHandler(signal, std::move(metric));
}

void TModule::AddMetric(const yplatform::ptree& config) {
    Impl->AddMetric(config);
}

bool TModule::IsMetricPresent(const std::string& signal) {
    return Impl->IsMetricPresent(signal);
}

} // namespace NYmodUnistat

REGISTER_MODULE(NYmodUnistat::TModule)
