#pragma once

#include "unistat.h"

#include <yplatform/module.h>
#include <yplatform/ptree.h>

#include <memory>

namespace NYmodUnistat {

class TModuleImpl;

class TModule : public IUnistat, public yplatform::module {
public:
    TModule();
    ~TModule() override;

    void init(const yplatform::ptree& configuration);

    void Push(const std::string& signal, double value) override;

    TMetric::TValue GetValue(const std::string& signal, bool reset) override;
    TValues GetValues(bool reset) override;
    std::string GetValuesInJson(bool reset) override;

    void ResetAll() override;

    TMetricPtr SetHandler(const std::string& signal, TMetricPtr metric) override;

    void AddMetric(const yplatform::ptree& config) override;
    bool IsMetricPresent(const std::string& signal) override;

private:
    std::unique_ptr<TModuleImpl> Impl;
};

} // namespace NYmodUnistat
