#pragma once

#include "metrics/metric.h"

#include <yplatform/ptree.h>

#include <string>
#include <vector>

namespace NYmodUnistat {

class IUnistat {
public:
    struct TMetricValue {
        std::string Signal;
        std::string Suffix;
        TMetric::TValue Value;
    };

    using TValues = std::vector<TMetricValue>;

    virtual ~IUnistat() = default;

    virtual void Push(const std::string& signal, double value) = 0;

    virtual TMetric::TValue GetValue(const std::string& signal, bool reset) = 0;
    virtual TValues GetValues(bool reset) = 0;
    virtual std::string GetValuesInJson(bool reset) = 0;

    virtual void ResetAll() = 0;

    virtual TMetricPtr SetHandler(const std::string& signal, TMetricPtr metric) = 0;
    virtual void AddMetric(const yplatform::ptree& config) = 0;
    virtual bool IsMetricPresent(const std::string& signal) = 0;
};

} // namespace NYmodUnistat
