#pragma once

#include <mail/ymod_unistat/lib/metrics/metric.h>

#include <functional>

namespace NYmodUnistat::NTesting {

class TCustomMetric : public TMetric {
public:
    using TPushHandler = std::function<void(double)>;
    using TValueHandler = std::function<TValue(bool)>;
    using TResetHandler = std::function<void()>;

    TCustomMetric(TPushHandler pushHandler, TValueHandler valueHandler, TResetHandler resetHandler)
        : PushHandler(std::move(pushHandler))
        , ValueHandler(std::move(valueHandler))
        , ResetHandler(std::move(resetHandler))
    {}

    void Push(double value) override {
        PushHandler(value);
    }

    TValue GetValue(bool reset) override {
        return ValueHandler(reset);
    }

    void Reset() override {
        ResetHandler();
    }

private:
    TPushHandler PushHandler;
    TValueHandler ValueHandler;
    TResetHandler ResetHandler;
};

} // namespace NYmodUnistat::NTesting
