#include <mail/ymod_unistat/lib/metrics/histogram_metric.h>

#include <library/cpp/testing/unittest/gtest.h>

using namespace NYmodUnistat;

bool CompareValues(TMetric::THistogramValues actual, TMetric::THistogramValues expected) {
    return actual == expected;
}

TEST(HistogramMetric, Common) {
    THistogramMetric::TBorders borders = {10, 20, 30, 40};
    auto metric = std::make_unique<THistogramMetric>(borders);
    auto values = std::get<TMetric::THistogramValues>(metric->GetValue(false));
    EXPECT_TRUE(CompareValues(values, {{10, 0}, {20, 0}, {30, 0}, {40, 0}}));

    metric->Push(10);
    metric->Push(1);
    metric->Push(34);
    metric->Push(50);
    metric->Push(11);
    values = std::get<TMetric::THistogramValues>(metric->GetValue(false));
    EXPECT_TRUE(CompareValues(values, {{10, 2}, {20, 0}, {30, 1}, {40, 1}}));
    values = std::get<TMetric::THistogramValues>(metric->GetValue(true));
    EXPECT_TRUE(CompareValues(values, {{10, 2}, {20, 0}, {30, 1}, {40, 1}}));
    values = std::get<TMetric::THistogramValues>(metric->GetValue(true));
    EXPECT_TRUE(CompareValues(values, {{10, 0}, {20, 0}, {30, 0}, {40, 0}}));

    metric->Push(22);
    values = std::get<TMetric::THistogramValues>(metric->GetValue(true));
    EXPECT_TRUE(CompareValues(values, {{10, 0}, {20, 1}, {30, 0}, {40, 0}}));
    metric->Reset();
    values = std::get<TMetric::THistogramValues>(metric->GetValue(true));
    EXPECT_TRUE(CompareValues(values, {{10, 0}, {20, 0}, {30, 0}, {40, 0}}));
}
