#include <mail/ymod_unistat/lib/metrics/average_metric.h>
#include <mail/ymod_unistat/lib/metrics/last_value_metric.h>
#include <mail/ymod_unistat/lib/metrics/max_metric.h>
#include <mail/ymod_unistat/lib/metrics/min_metric.h>
#include <mail/ymod_unistat/lib/metrics/sum_metric.h>
#include <mail/ymod_unistat/lib/metrics/sum_none_metric.h>

#include <library/cpp/testing/unittest/gtest.h>

using namespace NYmodUnistat;

TEST(NumericalMetrics, TAverageMetric) {
    auto metric = std::make_unique<TAverageMetric>();
    auto value = std::get<double>(metric->GetValue(false));
    EXPECT_DOUBLE_EQ(value, 0);

    metric->Push(10);
    metric->Push(20);
    value = std::get<double>(metric->GetValue(false));
    EXPECT_DOUBLE_EQ(value, 15);
    value = std::get<double>(metric->GetValue(true));
    EXPECT_DOUBLE_EQ(value, 15);
    value = std::get<double>(metric->GetValue(true));
    EXPECT_DOUBLE_EQ(value, 0);

    metric->Push(10);
    value = std::get<double>(metric->GetValue(true));
    EXPECT_DOUBLE_EQ(value, 10);
    metric->Reset();
    value = std::get<double>(metric->GetValue(true));
    EXPECT_DOUBLE_EQ(value, 0);
}

TEST(NumericalMetrics, TLastValueMetric) {
    auto metric = std::make_unique<TLastValueMetric>(100);
    auto value = std::get<double>(metric->GetValue(false));
    EXPECT_DOUBLE_EQ(value, 100);

    metric->Push(10);
    metric->Push(20);
    value = std::get<double>(metric->GetValue(false));
    EXPECT_DOUBLE_EQ(value, 20);
    value = std::get<double>(metric->GetValue(true));
    EXPECT_DOUBLE_EQ(value, 20);
    value = std::get<double>(metric->GetValue(true));
    EXPECT_DOUBLE_EQ(value, 100);

    metric->Push(10);
    value = std::get<double>(metric->GetValue(false));
    EXPECT_DOUBLE_EQ(value, 10);
    metric->Reset();
    value = std::get<double>(metric->GetValue(false));
    EXPECT_DOUBLE_EQ(value, 100);
}

TEST(NumericalMetrics, TMaxMetric) {
    auto metric = std::make_unique<TMaxMetric>(100);
    auto value = std::get<double>(metric->GetValue(false));
    EXPECT_DOUBLE_EQ(value, 100);

    metric->Push(200);
    metric->Push(90);
    value = std::get<double>(metric->GetValue(false));
    EXPECT_DOUBLE_EQ(value, 200);
    value = std::get<double>(metric->GetValue(true));
    EXPECT_DOUBLE_EQ(value, 200);
    value = std::get<double>(metric->GetValue(true));
    EXPECT_DOUBLE_EQ(value, 100);

    metric->Push(300);
    value = std::get<double>(metric->GetValue(false));
    EXPECT_DOUBLE_EQ(value, 300);
    metric->Reset();
    value = std::get<double>(metric->GetValue(false));
    EXPECT_DOUBLE_EQ(value, 100);
}

TEST(NumericalMetrics, TMinMetric) {
    auto metric = std::make_unique<TMinMetric>(100);
    auto value = std::get<double>(metric->GetValue(false));
    EXPECT_DOUBLE_EQ(value, 100);

    metric->Push(90);
    metric->Push(200);

    value = std::get<double>(metric->GetValue(false));
    EXPECT_DOUBLE_EQ(value, 90);
    value = std::get<double>(metric->GetValue(true));
    EXPECT_DOUBLE_EQ(value, 90);
    value = std::get<double>(metric->GetValue(true));
    EXPECT_DOUBLE_EQ(value, 100);

    metric->Push(80);
    value = std::get<double>(metric->GetValue(false));
    EXPECT_DOUBLE_EQ(value, 80);
    metric->Reset();
    value = std::get<double>(metric->GetValue(false));
    EXPECT_DOUBLE_EQ(value, 100);
}

TEST(NumericalMetrics, TSumMetric) {
    auto metric = std::make_unique<TSumMetric>(100);
    auto value = std::get<double>(metric->GetValue(false));
    EXPECT_DOUBLE_EQ(value, 100);

    metric->Push(100);
    metric->Push(200);
    value = std::get<double>(metric->GetValue(false));
    EXPECT_DOUBLE_EQ(value, 400);
    value = std::get<double>(metric->GetValue(true));
    EXPECT_DOUBLE_EQ(value, 400);
    value = std::get<double>(metric->GetValue(true));
    EXPECT_DOUBLE_EQ(value, 100);

    metric->Push(80);
    value = std::get<double>(metric->GetValue(false));
    EXPECT_DOUBLE_EQ(value, 180);
    metric->Reset();
    value = std::get<double>(metric->GetValue(false));
    EXPECT_DOUBLE_EQ(value, 100);
}

TEST(NumericalMetrics, TSumNoneMetric) {
    auto metric = std::make_unique<TSumNoneMetric>(100);
    auto variantValue = metric->GetValue(false);
    EXPECT_NE(std::get_if<std::monostate>(&variantValue), nullptr);

    metric->Push(100);
    metric->Push(200);
    auto value = std::get<double>(metric->GetValue(false));
    EXPECT_DOUBLE_EQ(value, 400);
    value = std::get<double>(metric->GetValue(true));
    EXPECT_DOUBLE_EQ(value, 400);
    variantValue = metric->GetValue(false);
    EXPECT_NE(std::get_if<std::monostate>(&variantValue), nullptr);

    metric->Push(80);
    value = std::get<double>(metric->GetValue(false));
    EXPECT_DOUBLE_EQ(value, 180);
    metric->Reset();
    variantValue = metric->GetValue(false);
    EXPECT_NE(std::get_if<std::monostate>(&variantValue), nullptr);
}
