#include <ymod_webserver/server.h>
#include <ymod_httpclient/client.h>
#include <yplatform/coroutine.h>
#include <iostream>

#ifndef _LIBCPP_HAS_NO_COROUTINES
using namespace yplatform;
using namespace boost::asio;

async_void move_json(ymod_webserver::http::stream_ptr stream)
{
    yhttp::client client(stream->get_io_context());
    auto [error, response] = co_await client.async_run(
        stream->ctx(), yhttp::request::GET("https://api.direct.yandex.ru/v4/json"), use_awaitable);
    if (!error) stream->result(ymod_webserver::codes::ok, response.body);
}

int main()
{
    io_context io;
    log::init_console(io);
    ymod_webserver::settings settings(ymod_webserver::endpoint("::", 8080));
    settings.access_log = log::find(io, "global");
    ymod_webserver::server server(io, settings);
    server.bind({}, { "/move_json" }, move_json);
    server.start();
    io.run();
    return 0;
}
#else
int main()
{
}
#endif