#include <ymod_webserver/server.h>
#include <random>

int random(int max)
{
    static thread_local std::mt19937 generator(time(0));
    std::uniform_int_distribution<int> distribution(0, max);
    return distribution(generator);
}

int main(int argc, char* argv[])
{
    if (argc <= 2) return 1;

    int port = atoi(argv[1]);
    int ratio = atoi(argv[2]);

    boost::asio::io_service io;
    yplatform::log::init_console(io);
    ymod_webserver::settings settings;
    settings.endpoints.emplace("", ymod_webserver::endpoint("", "::", port));
    settings.access_log = yplatform::log::find(io, "global");
    ymod_webserver::server server(io, settings);
    server.bind("", { "/list_json" }, [ratio](ymod_webserver::http::stream_ptr stream) {
        auto randval = random(99);
        if (randval < ratio)
        {
            stream->set_code(ymod_webserver::codes::ok);
            stream->result_body("[]");
        }
        else
        {
            stream->set_code(ymod_webserver::codes::internal_server_error);
            stream->result_body("");
        }
    });
    server.start();
    io.run();
    return 0;
}
