#include <ymod_webserver/server.h>

int main()
{
    boost::asio::io_service io;
    yplatform::log::init_console(io);
    ymod_webserver::settings settings;
    settings.endpoints.emplace("", ymod_webserver::endpoint("", "::", 8080));
    settings.access_log = yplatform::log::find(io, "global");
    ymod_webserver::server server(io, settings);
    server.bind("", { "/ping" }, [](ymod_webserver::http::stream_ptr stream) {
        stream->set_code(ymod_webserver::codes::ok);
        stream->result_body("pong");
    });
    server.start();
    io.run_for(std::chrono::seconds(10));
    return 0;
}
