#include <ymod_webserver/server.h>
#include <yplatform/find.h>
#include <yplatform/loader.h>
#include <yplatform/module_registration.h>
#include <iostream>

using namespace ymod_webserver;

struct rate_limit : yplatform::module
{
    rate_limit()
    {
        auto server = yplatform::find<ymod_webserver::server>("web_server");
        server->bind("", { "/ping" }, [](http::stream_ptr stream) {
            stream->set_code(codes::ok);
            stream->result_body("pong");
        });
        server->bind("", { "/v1/foo" }, [](http::stream_ptr stream) {
            stream->set_code(codes::ok);
            stream->result_body("bar");
        });
    }
};

int main(int argc, char* argv[])
{
    if (argc != 2)
    {
        std::cout << "usage " << argv[0] << " <config>\n";
        return 1;
    }

    return yplatform_start(argv[1]);
}

REGISTER_MODULE(rate_limit);
