#pragma once

#include <ymod_webserver/types.h>
#include <ymod_webserver/codes.h>

namespace ymod_webserver { namespace codes {

enum code
{
    continue_request = 100,    // 0
    switching_protocols = 101, // 1

    ok = 200,                     // 2
    created = 201,                // 3
    accepted = 202,               // 4
    non_authoritative_info = 203, // 5
    no_content = 204,             // 6
    reset_content = 205,          // 7
    partial_content = 206,        // 8

    multiple_choices = 300,  // 9
    moved_permanently = 301, // 10
    found = 302,             // 11
    see_other = 303,         // 12
    not_modified = 304,      // 13
    use_proxy = 305,         // 14
    // uunknown               = 306, //15
    temporary_redirect = 307, // 16

    bad_request = 400,              // 17
    unauthorized = 401,             // 18
    payment_required = 402,         // 19
    forbidden = 403,                // 20
    not_found = 404,                // 21
    method_not_allowed = 405,       // 22
    not_acceptable = 406,           // 23
    proxy_auth_required = 407,      // 24
    request_timeout = 408,          // 25
    conflict = 409,                 // 26
    gone = 410,                     // 27
    length_required = 411,          // 28
    precondition_failed = 412,      // 29
    request_entity_too_large = 413, // 30
    request_uri_too_long = 414,     // 31
    unsupported_media_type = 415,   // 32
    requested_range_not_st = 416,   // 33
    expectation_failed = 417,       // 34
    unprocessable = 422,            // 35
    too_many_requests = 429,        // 36
    client_closed_connection = 499, // 37

    internal_server_error = 500, // 38
    not_implemented = 501,       // 39
    bad_gateway = 502,           // 40
    service_unavailable = 503,   // 41
    gateway_timeout = 504,       // 42
    version_not_supported = 505, // 43
};

struct reason
{
    static const string& get(int c)
    {
        static const int offset[] = { 0, 2, 9, 17, 38, 44 };
        int index;

        if (c == 422) return default_reasons[offset[4] - 3];
        if (c == 429) return default_reasons[offset[4] - 2];
        if (c == 499) return default_reasons[offset[4] - 1];

        switch (c / 100)
        {
        case 1:
        case 2:
        case 3:
        case 4:
        case 5:
            index = (c / 100) - 1;
            break;
        default:
            return unknown_reason;
        }

        int reason_index = c % 100 + offset[index];
        return (reason_index < offset[index + 1] ? default_reasons[reason_index] : unknown_reason);
    }

    static const string& get_unknown_reason()
    {
        return unknown_reason;
    }

private:
    static const string default_reasons[];
    static const string unknown_reason;
};

}}
