#pragma once

#include <ymod_webserver/response.h>

namespace ymod_webserver { namespace http {

struct expirable_stream
{
public:
    expirable_stream(stream_ptr stream);
    ~expirable_stream();

    context_ptr ctx();
    context_ptr context(); // alias for ctx()
    request_ptr request();

    bool is_open() const;
    void result(codes::code cd, const string& body = "");
    void result(codes::code cd, const string& reason, const string& body);
    void store_intermediate_result(codes::code cd, const string& reason);
    void send_stored_result();
    yplatform::net::streamable_ptr result_stream(const std::size_t body_len);
    yplatform::net::streamable_ptr result_chunked();
    stream_ptr detach_stream();
    boost::asio::io_service& io_service();

private:
    stream_ptr get_stream() const;

    static constexpr codes::code DEFAULT_TIMEOUT_CODE = codes::gateway_timeout;
    mutable boost::mutex mutex_;
    ymod_webserver::http::stream_ptr stream_;
    ymod_webserver::request_ptr req_;
    yplatform::time_traits::timer_ptr timer_;
    codes::code stored_code_;
    string stored_reason_;

    friend boost::shared_ptr<expirable_stream> make_expirable_stream(
        stream_ptr,
        const yplatform::time_traits::duration&);
};

typedef boost::shared_ptr<expirable_stream> expirable_stream_ptr;
typedef boost::weak_ptr<expirable_stream> expirable_stream_weak_ptr;

expirable_stream_ptr make_expirable_stream(
    stream_ptr stream,
    const yplatform::time_traits::duration& timeout);

}}

#include <ymod_webserver/impl/expirable_stream.h>