#pragma once

#include <ymod_webserver/request.h>
#include <ymod_webserver/response.h>
#include <ymod_webserver/websocket.h>

namespace ymod_webserver {

namespace request_body {
enum read_mode
{
    read_mode_stream,       // use body read stream from response (now not supported)
    read_mode_buffer,       // read body to buffer in response
    read_mode_parsed_buffer // read body to buffer and parse it if Content-Type supported
};
}

namespace context_mode {
enum create
{
    create_nothing = 0,
    create_always = 1,
    create_per_request = 2
};
}

class handler
{
public:
    // for expect 100-continue, and get parse post request mode.
    // if http error detected throw ymod_webserver::http_error
    virtual request_body::read_mode parse_post_mode(request_ptr)
    {
        return request_body::read_mode_parsed_buffer;
    }

    /// Deprecated.
    virtual context_mode::create create_context(const request_ptr&)
    {
        return context_mode::create_per_request;
    }

    virtual void execute(request_ptr req, response_ptr stream) = 0;

    // upgrade session to websocket proto. not supported by default.
    virtual void upgrade_to_websocket(request_ptr)
    {
        throw http_error("handler", "Not Implemented", "websocket_upgrade method not implemented")
            << http_result_code(codes::not_implemented);
    }

    virtual void execute_websocket(websocket::output_stream_ptr)
    {
    }

    virtual ~handler() = default;
};

typedef boost::shared_ptr<handler> handler_ptr;

}
