#pragma once

#include <ymod_webserver/response.h>
#include <ymod_webserver/websocket.h>
#include <ymod_webserver/codes.h>
#include <ymod_webserver/methods/detail/default_answers.h>

namespace ymod_webserver { namespace default_answers {

template <typename StreamPtr>
void send_bad_request(StreamPtr stream, const std::string& text)
{
    stream->result(codes::bad_request, text);
}

template <>
inline void send_bad_request<websocket::stream_ptr>(
    websocket::stream_ptr stream,
    const std::string& text)
{
    stream->close_connection(websocket::codes::bad_request, text);
}

template <typename... CallArgs>
void send_not_found(request_ptr, http::stream_ptr stream, CallArgs&&... args)
{
    send_not_found(stream, args...);
}

template <typename AbstractStream, typename... CallArgs>
void send_not_found(AbstractStream stream, CallArgs&&...)
{
    stream->result(codes::not_found, "The requested URL was not found");
}

template <typename... CallArgs>
void send_not_found(websocket::stream_ptr stream, CallArgs&&...)
{
    stream->close_connection(websocket::codes::not_found, "The requested URL was not found");
}

template <typename StreamPtr>
void send_no_argument_error(StreamPtr stream, const char* arg_name)
{
    send_bad_request(stream, std::string(NO_ARGUMENT_MSG " \"") + arg_name + "\"");
}

template <typename StreamPtr>
inline void send_forbidden(StreamPtr stream, const std::string& text)
{
    stream->result(codes::forbidden, text);
}

template <>
inline void send_forbidden<websocket::stream_ptr>(
    websocket::stream_ptr stream,
    const std::string& text)
{
    stream->close_connection(websocket::codes::forbidden, text);
}

template <typename StreamPtr>
inline void send_service_unavailable(StreamPtr stream)
{
    stream->result(
        ymod_webserver::codes::service_unavailable,
        ymod_webserver::codes::reason::get(ymod_webserver::codes::service_unavailable));
}

template <>
inline void send_service_unavailable<websocket::stream_ptr>(websocket::stream_ptr stream)
{
    stream->close_connection(
        websocket::codes::service_unavailable,
        ymod_webserver::codes::reason::get(ymod_webserver::codes::service_unavailable));
}

} // namespace default_answers
} // namespace ymod_webserver