#pragma once

#include <tuple>

namespace ymod_webserver { namespace detail {

// Recusively goes down to next function, adding each tuple's element type
// to T... arguments.
template <std::size_t N, typename Tuple, typename... T>
struct results_tuple
    : results_tuple<N - 1, Tuple, typename std::tuple_element<N - 1, Tuple>::type::value_type, T...>
{
};

// Stops recursion then all elements in T...,
// defines final type tuple of elements with types same with element::value_type
// in the original tuple.
template <typename Tuple, typename... T>
struct results_tuple<0, Tuple, T...>
{
    typedef std::tuple<T...> type;
};

// Declares std::tuple<T1::value_type,T2::value_type,T3::value_type,...>
// for std::tuple<T1,T2,T3,...>
template <typename Tuple>
struct evaluate_results_tuple
{
private:
    typedef Tuple tuple_type;
    typedef typename std::tuple_element<std::tuple_size<tuple_type>::value - 1, tuple_type>::type
        last_element_type;

public:
    typedef typename results_tuple<
        std::tuple_size<tuple_type>::value - 1,
        tuple_type,
        typename last_element_type::value_type>::type type;
};

template <std::size_t...>
struct sequence
{
};

template <std::size_t N, std::size_t... S>
struct gensequence : gensequence<N - 1, N - 1, S...>
{
};

// Generates sequenc <1,2,3,...N> in S...
template <std::size_t... S>
struct gensequence<0, S...>
{
    typedef sequence<S...> type;
};

// Calls function using std::get() and ellipsis mechanism.
template <typename Tuple, typename F, std::size_t... S>
inline void unpack_tuple_and_call(const Tuple& tuple, F& f, sequence<S...>)
{
    f(std::get<S>(tuple)...);
}

// Unpack tuple<T1,T2,T3> and calls a function f(T1,T2,T3)).
template <typename F, typename... Args>
inline void call_with_tuple_args(F& f, const std::tuple<Args...>& tuple)
{
    unpack_tuple_and_call(tuple, f, typename gensequence<sizeof...(Args)>::type());
}

} // namespace detail
} // namespace ymod_webserver
