#pragma once

#include <ymod_webserver/context.h>
#include <ymod_webserver/receiver.h>
#include <ymod_webserver/request_base.h>
#include <boost/function.hpp>

namespace ymod_webserver {

struct request : public request_base
{
    // session context
    context_ptr context;
    // stream for async read post body.
    receiver_ptr post_receiver;

    request(context_ptr context = context_ptr()) : context(std::move(context))
    {
    }

    ~request()
    {
        if (on_destroy_callback) try
            {
                on_destroy_callback(this);
            }
            catch (...)
            {
            }
    }

    context_ptr ctx() const
    {
        return context;
    }

    boost::function<void(request*)> on_destroy_callback;
};

typedef boost::shared_ptr<request> request_ptr;
typedef boost::shared_ptr<const request> request_const_ptr;

}
