#pragma once

#include <map>
#include <deque>
#include <boost/optional.hpp>
#include <ymod_webserver/uri.h>
#include <ymod_webserver/types.h>
#include <ymod_webserver/header.h>
#include <ymod_webserver/methods.h>
#include <ymod_webserver/iabstract.h>
#include <yplatform/zerocopy/segment.h>

namespace ymod_webserver {

struct request_base : public content_part
{
    request_base() : proto_version(0, 0)
    {
    }

    string raw_url; // TODO use string_view after migration to C++17
    string raw_request_line;
    methods::http_method method{ methods::mth_invalid };
    http_uri url;
    string bound_path;
    boost::optional<host_info> origin;
    host_info vhost;
    std::pair<uint8_t, uint8_t> proto_version;

    connection_header connection{ connection_keep_alive }; // Header connection: close
    transfer_encoding_header transfer_encoding{ transfer_encoding_identity };
    content_encoding_header content_encoding{ content_encoding_identity };
    upgrade_proto_header upgrade_to{ upgrade_none };
    yplatform::zerocopy::segment raw_body;

    accept_header_value accept;
    accept_encoding_header_value accept_encoding;
};

typedef boost::shared_ptr<request_base> request_base_ptr;
typedef boost::weak_ptr<request_base> request_base_weak_ptr;

}
